## Lua & NodeMCU Resources

The following is a list of links to use as reference for coding in Lua and using NodeMCU:
* [NodeMCU Documentation](https://nodemcu.readthedocs.io/en/master/) - This has the documentation for all the NodeMCU modules in the firmware.  We'll use this a lot!
* [Lua Reference Manual](https://www.lua.org/manual/5.1/) - Official reference manual, with all the language help and function reference
* [Interactive Lua Tutorial](http://luatut.com/crash_course.html) - A tutorial for Lua that runs in your browser.  Just open the link, press escape to open the terminal window, and you can work your way through the course. 
* [Programming in Lua](http://www.lua.org/pil/contents.html) - A good reference book on how to do things in Lua
* [Short Lua Tutorials](http://lua-users.org/wiki/TutorialDirectory) - A bunch of short Lua tutorials on basic topics
* [Some NodeMCU Lua Examples](https://github.com/nodemcu/nodemcu-firmware/tree/master/lua_examples) - From the official firmware
* [Lua Users](http://lua-users.org/wiki/LuaDirectory) - Lots of useful Lua information and short example code
* [Lua Programming Gems](https://www.lua.org/gems/) - Rather advanced, but some useful stuff here, especially the chapter on performance tips
* [NodeMCU Source Code](https://github.com/nodemcu/nodemcu-firmware) - Source code for nodemcu.
* [Lua Modules Not in Firmware](https://github.com/nodemcu/nodemcu-firmware/tree/master/lua_modules) - Some NodeMCU modules for sensors not in the firmware
* [ESP8266 Wiki](http://www.esp8266.com/wiki/doku.php?id=start) - An exhaustive reference on the ESP8266 in general


## Useful Lua Functions
* [pcall()](https://www.lua.org/manual/5.1/manual.html#pdf-pcall) - catch errors, [more here](https://www.lua.org/pil/8.4.html)
* [Math functions](https://www.lua.org/manual/5.1/manual.html#5.6)
